<?php $__env->startSection('title','Order Invoice'); ?>
<?php $__env->startSection('content'); ?>
<style>
    .customer-invoice {
        margin: 25px 0;
    }
    .invoice_btn{
        margin-bottom: 15px;
    }
    p{
        margin:0;
    }
    td{
        font-size: 16px;
    }
   @page { 
    margin:0px;
    }
   @media print {
    .invoice-innter{
        margin-left: -120px !important;
    }
    .invoice_btn{
        margin-bottom: 0 !important;
    }
    td{
        font-size: 18px;
    }
    p{
        margin:0;
    }
    header,footer,.no-print,.left-side-menu,.navbar-custom {
      display: none !important;
    }
  }
</style>

<section class="customer-invoice ">
    <div class="container">
        <div class="row">
            <div class="col-sm-6">
                <a href="/admin/order/all" class="no-print"><strong><i class="fe-arrow-left"></i> Back To Order</strong></a>
            </div>
            <div class="col-sm-6 text-end">
                <button onclick="printFunction()" class="no-print btn btn-xs btn-success waves-effect waves-light"><i class="fa fa-print"></i></button>
            </div>

            <div class="col-sm-12 mt-3">
                <div class="invoice-innter" style="width:760px;margin: 0 auto;background: #fff;overflow: hidden;padding: 30px;padding-top: 0;">
                    <table style="width:100%">
                        <tr>
                            <td style="width: 40%; float: left; padding-top: 15px;">
                                <img src="<?php echo e(asset($generalsetting->white_logo)); ?>" width="190px" style="margin-top:25px !important" alt="">
                                <p style="font-size: 14px; color: #222; margin: 20px 0;">
                                    <strong>Payment Method:</strong> 
                                    <span style="text-transform: uppercase;"><?php echo e($order->payment?$order->payment->payment_method:''); ?></span>
                                </p>

                                <!-- ✅ Payment Gateway + Status অংশ -->
                                <div style="margin-bottom:15px;">
                                    <p><strong>Payment Gateway:</strong> <?php echo e(ucfirst($order->payment_gateway ?? 'N/A')); ?></p>
                                    <p><strong>Payment Status:</strong></p>
                                    <select id="payment_status_<?php echo e($order->id); ?>" class="form-control no-print" style="width:auto; display:inline-block;">
                                        <option value="pending" <?php echo e($order->payment_status == 'pending' ? 'selected' : ''); ?>>Pending</option>
                                        <option value="paid" <?php echo e($order->payment_status == 'paid' ? 'selected' : ''); ?>>Paid</option>
                                        <option value="unpaid" <?php echo e($order->payment_status == 'unpaid' ? 'selected' : ''); ?>>Unpaid</option>
                                        <option value="failed" <?php echo e($order->payment_status == 'failed' ? 'selected' : ''); ?>>Failed</option>
                                    </select>
                                    <button class="btn btn-sm btn-success no-print" onclick="updatePaymentStatus(<?php echo e($order->id); ?>)">Update</button>
                                </div>
                                
                                <!-- ✅ Order Status Change (Manual) -->
                                <div style="margin-bottom:15px; padding: 10px; background: #f8f9fa; border-radius: 5px;">
                                    <p style="margin-bottom: 5px;"><strong>Order Status:</strong> 
                                        <span class="badge bg-<?php echo e($order->order_status == 6 ? 'success' : ($order->order_status == 11 ? 'danger' : 'warning')); ?>">
                                            <?php echo e($order->status ? $order->status->name : 'N/A'); ?>

                                        </span>
                                    </p>
                                    <?php if(isset($orderstatus)): ?>
                                    <div class="no-print">
                                        <select id="order_status_<?php echo e($order->id); ?>" class="form-control" style="width:auto; display:inline-block; margin-right: 5px;">
                                            <?php $__currentLoopData = $orderstatus; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($status->id); ?>" <?php echo e($order->order_status == $status->id ? 'selected' : ''); ?>>
                                                    <?php echo e($status->name); ?>

                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                        <button class="btn btn-sm btn-primary" onclick="updateOrderStatus(<?php echo e($order->id); ?>)">
                                            <i class="fa fa-save"></i> Update Status
                                        </button>
                                        <?php if($order->courier_type): ?>
                                        <br><small class="text-muted" style="margin-top: 5px; display: inline-block;">
                                            <i class="fa fa-truck"></i> Courier: <?php echo e(ucfirst($order->courier_type)); ?>

                                            <?php if($order->courier_tracking_id): ?>
                                                | Tracking: <?php echo e($order->courier_tracking_id); ?>

                                            <?php endif; ?>
                                            <br><span style="color: #6c757d; font-size: 11px;">(Auto-update from courier every 10 minutes)</span>
                                        </small>
                                        <?php endif; ?>
                                    </div>
                                    <?php endif; ?>
                                </div>
                                <!-- ✅ END -->

                                <div class="invoice_form">
                                    <p style="font-size:16px;line-height:1.8;color:#222"><strong>Invoice From:</strong></p>
                                    <p style="font-size:16px;line-height:1.8;color:#222"><?php echo e($generalsetting->name); ?></p>
                                    <p style="font-size:16px;line-height:1.8;color:#222"><?php echo e($contact->phone); ?></p>
                                    <p style="font-size:16px;line-height:1.8;color:#222"><?php echo e($contact->email); ?></p>
                            
<?php if(!empty($order->order_note) || !empty($order->note)): ?>
<p style="font-size:16px;line-height:1.8;color:#222">
    <strong>Order Note:</strong> <?php echo e($order->order_note ?? $order->note); ?>

</p>
<?php endif; ?>
									
                                </div>
                            </td>

                            <td  style="width:60%;float: left;">
                                <div class="invoice-bar" style=" background: #4DBC60; transform: skew(38deg); width: 100%; margin-left: 65px; padding: 20px 60px; ">
                                    <p style="font-size: 30px; color: #fff; transform: skew(-38deg); text-transform: uppercase; text-align: right; font-weight: bold;">Invoice</p>
                                </div>
                                <div class="invoice-bar" style="background: #fff; transform: skew(36deg); width: 72%; margin-left: 182px; padding: 12px 32px; margin-top: 6px;">
                                    <p style="font-size: 15px; color: #222;font-weight:bold; transform: skew(-36deg); text-align: right; padding-right: 18px">Invoice ID : <strong>#<?php echo e($order->invoice_id); ?></strong></p>
                                    <p style="font-size: 15px; color: #222;font-weight:bold; transform: skew(-36deg); text-align: right; padding-right: 32px">Invoice Date: <strong><?php echo e($order->created_at->format('d-m-y')); ?></strong></p>
                                </div>
                                <div class="invoice_to" style="padding-top: 20px;">
                                    <p style="font-size:16px;line-height:1.8;color:#222;text-align: right;"><strong>Invoice To:</strong></p>
                                    <p style="font-size:16px;line-height:1.8;color:#222;text-align: right;"><?php echo e($order->shipping?$order->shipping->name:''); ?></p>
                                    <p style="font-size:16px;line-height:1.8;color:#222;text-align: right;"><?php echo e($order->shipping?$order->shipping->phone:''); ?></p>
                                    <p style="font-size:16px;line-height:1.8;color:#222;text-align: right;"><?php echo e($order->shipping?$order->shipping->address:''); ?></p>
                                    <p style="font-size:16px;line-height:1.8;color:#222;text-align: right;"><?php echo e($order->shipping?$order->shipping->area:''); ?></p>
                                </div>
                            </td>
                        </tr>
                    </table>

                    <table class="table" style="margin-top: 30px;margin-bottom: 0;">
                        <thead style="background: #4DBC60; color: #fff;">
                            <tr>
                                <th>SL</th>
                                <th>Product</th>
                                <th>Price</th>
                                <th>Qty</th>
                                <th>Total</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                                // Check if this is a reseller order (once, outside loop)
                                // Reseller orders ALWAYS have customer_payable_amount field set
                                $isResellerOrderItem = !empty($order->customer_payable_amount);
                                
                                // For reseller orders: calculate custom_price from customer_payable_amount
                                $customPrice = null;
                                $totalProductValue = 0;
                                if ($isResellerOrderItem && $order->customer_payable_amount) {
                                    $customPrice = $order->customer_payable_amount - $order->shipping_charge;
                                    // Calculate total of all products (sum of sale_price * qty)
                                    foreach ($order->orderdetails as $od) {
                                        $totalProductValue += ($od->sale_price * $od->qty);
                                    }
                                }
                            ?>
                            <?php $__currentLoopData = $order->orderdetails; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                                // For reseller orders: Calculate price from customer_payable_amount proportionally
                                // customer_payable_amount = custom_price + shipping
                                // custom_price = reseller যে দামে sell করেছে (total)
                                // For normal orders: show sale_price (main price)
                                
                                if ($isResellerOrderItem && $customPrice && $totalProductValue > 0) {
                                    // Reseller order: Calculate per product price from customer_payable_amount
                                    // This product's share = (this product's value / total value) * custom_price
                                    $thisProductValue = $value->sale_price * $value->qty;
                                    $thisProductShare = ($thisProductValue / $totalProductValue) * $customPrice;
                                    $displayPrice = $thisProductShare / $value->qty; // Per unit price
                                } else {
                                    // Normal order: show sale_price (main price)
                                    $displayPrice = $value->sale_price;
                                }
                            ?>
                            <tr>
                                <td><?php echo e($loop->iteration); ?></td>
                                <td><?php echo e($value->product_name); ?> 
                                    <br> 
                                <?php
                                    $sizeDisplay = null;
                                    if ($value->size) {
                                        $sizeDisplay = $value->size->sizeName ?? $value->size->size_name ?? $value->size->name ?? null;
                                    } elseif ($value->product_size) {
                                        // If product_size is an ID, fetch the Size model
                                        $s = \App\Models\Size::find($value->product_size);
                                        $sizeDisplay = $s ? ($s->sizeName ?? $s->size_name ?? null) : null;
                                        // If still null, it might be a direct size name string
                                        if (!$sizeDisplay && !is_numeric($value->product_size)) {
                                            $sizeDisplay = $value->product_size;
                                        }
                                    }
                                ?>
                                <?php if($sizeDisplay): ?>
                                    <small>Size: <?php echo e($sizeDisplay); ?></small><br>
                                <?php endif; ?>   
                                <?php
                                    $displayColor = ($value->color && $value->color->name) ? $value->color->name : ($value->product_color ?: null);
                                ?>
                                <?php if($displayColor): ?>
                                    <small>Color: <?php echo e($displayColor); ?></small>
                                <?php endif; ?> 
                                </td>
                                <td>৳<?php echo e(number_format($displayPrice, 2)); ?></td>
                                <td><?php echo e($value->qty); ?></td>
                                <td>৳<?php echo e(number_format($displayPrice * $value->qty, 2)); ?></td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>

                    <div class="invoice-bottom">
                       <?php
    // Check if this is a reseller order
    // Reseller orders ALWAYS have customer_payable_amount field set
    $isResellerOrder = !empty($order->customer_payable_amount);

    // Calculate subtotal - for reseller orders, calculate from customer_payable_amount
    if ($isResellerOrder && $order->customer_payable_amount) {
        // customer_payable_amount = custom_price + shipping
        // custom_price = reseller যে দামে sell করেছে (total)
        // So subtotal = customer_payable_amount - shipping
        $subtotal = $order->customer_payable_amount - $order->shipping_charge;
    } else {
        // Normal order: calculate from sale_price
        $subtotal = 0;
        foreach ($order->orderdetails as $item) {
            $subtotal += ($item->sale_price * $item->qty);
        }
    }
    
    $shipping = $order->shipping_charge;
    $discount = $order->discount;
    
    // If reseller order, use customer_payable_amount, otherwise use amount
    $finalTotal = $isResellerOrder ? $order->customer_payable_amount : $order->amount;

    // Payment Table থেকে নেওয়া Paid/Advance Amount
    $advancePaid = \App\Models\Payment::where('order_id', $order->id)->sum('amount');

    // Due Amount
    $dueAmount = $finalTotal - $advancePaid;
?>

<table class="table" style="width: 300px; float: right; margin-bottom: 30px;">
    <tbody style="background:#f1f9f8">
        <?php if($isResellerOrder): ?>
            <tr style="background:#ffc107;color:#000">
                <td><strong><i class="fa fa-user-tag"></i> Reseller Order</strong></td>
                <td></td>
            </tr>
        <?php endif; ?>
        <tr>
            <td><strong>SubTotal</strong></td>
            <td><strong>৳<?php echo e(number_format($subtotal, 2)); ?></strong></td>
        </tr>
        <tr>
            <td><strong>Shipping(+)</strong></td>
            <td><strong>৳<?php echo e(number_format($shipping, 2)); ?></strong></td>
        </tr>
        <tr>
            <td><strong>Discount(-)</strong></td>
            <td><strong>৳<?php echo e(number_format($discount, 2)); ?></strong></td>
        </tr>

        <tr style="background:#4DBC60;color:#fff">
            <td><strong><?php echo e($isResellerOrder ? 'Customer Payable Amount' : 'Final Total'); ?></strong></td>
            <td><strong>৳<?php echo e(number_format($finalTotal, 2)); ?></strong></td>
        </tr>

        
        <?php if($advancePaid > 0 && $advancePaid < $finalTotal): ?>
            <tr>
                <td><strong>Advance Paid</strong></td>
                <td><strong>৳<?php echo e(number_format($advancePaid, 2)); ?></strong></td>
            </tr>
            <tr>
                <td><strong>Due Amount</strong></td>
                <td><strong>৳<?php echo e(number_format($dueAmount, 2)); ?></strong></td>
            </tr>
        <?php endif; ?>
    </tbody>
</table>


                        <div class="terms-condition" style="overflow: hidden; width: 100%; text-align: center; padding: 20px 0; border-top: 1px solid #ddd;">
                            <h5 style="font-style: italic;"><a href="<?php echo e(route('page',['slug'=>'terms-condition'])); ?>">Terms & Conditions</a></h5>
                            <p style="text-align: center; font-style: italic; font-size: 15px; margin-top: 10px;">* This is a computer generated invoice, does not require any signature.</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- ✅ JS -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
<link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css" rel="stylesheet">

<script>
function printFunction() {
    window.print();
}

function updatePaymentStatus(orderId) {
    let status = document.getElementById('payment_status_' + orderId).value;

    fetch('<?php echo e(route("admin.order.updatePaymentStatus")); ?>', {
        method: 'POST',
        headers: {
            'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
            'Content-Type': 'application/json'
        },
        body: JSON.stringify({ order_id: orderId, payment_status: status })
    })
    .then(res => res.json())
    .then(data => {
        if (data.status === 'success') {
            toastr.success(data.message, 'Success!');
        } else {
            toastr.error(data.message, 'Error!');
        }
    })
    .catch(err => {
        toastr.error('Something went wrong!', 'Error!');
    });
}

function updateOrderStatus(orderId) {
    let status = document.getElementById('order_status_' + orderId).value;
    
    if (!status) {
        toastr.warning('Please select a status', 'Warning!');
        return;
    }

    // Confirm before changing status
    if (!confirm('Are you sure you want to change the order status? This will manually override any automatic courier status updates.')) {
        return;
    }

    fetch('<?php echo e(route("admin.order.updateSingleStatus")); ?>', {
        method: 'POST',
        headers: {
            'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
            'Content-Type': 'application/json'
        },
        body: JSON.stringify({ order_id: orderId, order_status: status })
    })
    .then(res => res.json())
    .then(data => {
        if (data.status === 'success') {
            toastr.success(data.message, 'Success!');
            // Reload page after 1 second to show updated status
            setTimeout(function() {
                location.reload();
            }, 1000);
        } else {
            toastr.error(data.message, 'Error!');
        }
    })
    .catch(err => {
        toastr.error('Something went wrong!', 'Error!');
        console.error(err);
    });
}
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backEnd.layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/creativedesignbd/ecommerce1.creativedesign.com.bd/resources/views/backEnd/order/invoice.blade.php ENDPATH**/ ?>