

<?php $__env->startSection('title', $product->name); ?>
<?php $__env->startSection('page-title', 'প্রোডাক্ট বিস্তারিত'); ?>

<?php $__env->startPush('styles'); ?>
<style>
    .product-detail-card {
        background: #fff;
        border-radius: 16px;
        padding: 24px;
        border: 1px solid #e2e8f0;
        box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.05);
    }

    .product-main-image {
        width: 100%;
        height: 400px;
        object-fit: cover;
        border-radius: 12px;
        background: #f8fafc;
    }

    .product-thumbnail {
        width: 80px;
        height: 80px;
        object-fit: cover;
        border-radius: 8px;
        cursor: pointer;
        border: 2px solid transparent;
        transition: all 0.2s;
    }

    .product-thumbnail:hover,
    .product-thumbnail.active {
        border-color: #4f46e5;
    }

    .profit-badge {
        background: #ecfdf5;
        color: #059669;
        padding: 8px 16px;
        border-radius: 8px;
        font-weight: 700;
        display: inline-block;
    }

    .price-section {
        background: #f8fafc;
        padding: 20px;
        border-radius: 12px;
        border: 2px solid #e2e8f0;
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>

    <div class="row g-4">
        <div class="col-lg-8">
            <!-- Product Images -->
            <div class="product-detail-card mb-4">
                <div class="row g-3">
                    <div class="col-md-2">
                        <div class="d-flex flex-column gap-2">
                            <?php if($product->images && $product->images->count() > 0): ?>
                                <?php $__currentLoopData = $product->images->take(4); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <img src="<?php echo e(asset($image->image)); ?>" 
                                     class="product-thumbnail <?php echo e($loop->first ? 'active' : ''); ?>" 
                                     onclick="changeMainImage('<?php echo e(asset($image->image)); ?>', this)"
                                     alt="Product Image">
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php elseif($product->image && $product->image->image): ?>
                                <img src="<?php echo e(asset($product->image->image)); ?>" 
                                     class="product-thumbnail active" 
                                     onclick="changeMainImage('<?php echo e(asset($product->image->image)); ?>', this)"
                                     alt="Product Image">
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="col-md-10">
                        <img id="mainProductImage" 
                             src="<?php echo e(asset($product->image && $product->image->image ? $product->image->image : 'storage/uploads/placeholder.png')); ?>" 
                             class="product-main-image" 
                             alt="<?php echo e($product->name); ?>">
                    </div>
                </div>
            </div>

            <!-- Product Details -->
            <div class="product-detail-card">
                <h4 class="fw-bold mb-3"><?php echo e($product->name); ?></h4>
                
                <div class="mb-3">
                    <span class="badge bg-primary me-2"><?php echo e($product->category->name ?? 'N/A'); ?></span>
                    <?php if($product->brand): ?>
                        <span class="badge bg-secondary"><?php echo e($product->brand->name); ?></span>
                    <?php endif; ?>
                    <?php if($product->product_code): ?>
                        <span class="badge bg-light text-dark">Code: <?php echo e($product->product_code); ?></span>
                    <?php endif; ?>
                </div>

                <div class="mb-4">
                    <h6 class="fw-bold mb-2">বর্ণনা</h6>
                    <div class="text-muted">
                        <?php echo $product->description ?? 'কোন বর্ণনা নেই'; ?>

                    </div>
                </div>

                <?php if($product->note): ?>
                <div class="alert alert-info">
                    <strong>Note:</strong> <?php echo e($product->note); ?>

                </div>
                <?php endif; ?>
            </div>
        </div>

        <div class="col-lg-4">
            <!-- Price & Order Section -->
            <div class="product-detail-card mb-4">
                <div class="price-section text-center mb-4">
                    <small class="text-secondary d-block mb-2" style="font-size: 12px;">রিসেলার প্রাইস</small>
                    <h2 class="fw-bold text-primary mb-0">৳ <?php echo e(number_format($product->reseller_price, 0)); ?></h2>
                    <?php if($product->old_price && $product->old_price > $product->reseller_price): ?>
                    <small class="text-muted text-decoration-line-through">
                        ৳<?php echo e(number_format($product->old_price, 0)); ?>

                    </small>
                    <?php endif; ?>
                </div>

                <div class="mb-4 text-center">
                    <div class="profit-badge">
                        <i class="fas fa-coins me-1"></i> আপনার লাভ: ৳<?php echo e(number_format($product->profit, 0)); ?>

                    </div>
                </div>

                <div class="row g-2 mb-4">
                    <div class="col-6">
                        <div class="text-center p-3 bg-light rounded">
                            <small class="text-muted d-block">স্টক</small>
                            <strong class="text-dark" id="stock-display"><?php echo e($product->stock); ?></strong>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="text-center p-3 bg-light rounded">
                            <small class="text-muted d-block">রেগুলার প্রাইস</small>
                            <strong class="text-dark">৳<?php echo e(number_format($product->new_price, 0)); ?></strong>
                        </div>
                    </div>
                </div>

                
                <?php
                    $productcolors = $product->variantPrices->pluck('color')->unique('id')->filter();
                    $productsizes = $product->variantPrices->pluck('size')->unique('id')->filter();
                ?>

                <?php if($productcolors->count() > 0 || $productsizes->count() > 0): ?>
                <div class="mb-4">
                    
                    <?php if($productcolors->count() > 0): ?>
                    <div class="mb-3">
                        <label class="form-label fw-semibold mb-2">কালর নির্বাচন করুন <span class="text-danger">*</span></label>
                        <div class="d-flex flex-wrap gap-2">
                            <?php $__currentLoopData = $productcolors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $procolor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="form-check form-check-inline">
                                <input class="form-check-input color-radio" 
                                       type="radio" 
                                       name="product_color" 
                                       id="color-<?php echo e($procolor->id); ?>" 
                                       value="<?php echo e($procolor->id); ?>"
                                       required>
                                <label class="form-check-label" for="color-<?php echo e($procolor->id); ?>">
                                    <span class="badge" style="background-color: <?php echo e($procolor->color ?? '#ccc'); ?>; padding: 8px 12px; border-radius: 4px;">
                                        <?php echo e($procolor->colorName ?? $procolor->name ?? 'Color'); ?>

                                    </span>
                                </label>
                            </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                    <?php endif; ?>

                    
                    <?php if($productsizes->count() > 0): ?>
                    <div class="mb-3">
                        <label class="form-label fw-semibold mb-2">সাইজ নির্বাচন করুন <span class="text-danger">*</span></label>
                        <select name="product_size" id="product_size" class="form-select size-select" required>
                            <option value="">সাইজ নির্বাচন করুন</option>
                            <?php $__currentLoopData = $productsizes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $prosize): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($prosize->id); ?>" data-stock="<?php echo e($prosize->pivot->stock ?? $product->stock); ?>">
                                <?php echo e($prosize->sizeName ?? $prosize->name); ?> 
                                <?php if(isset($prosize->pivot->stock)): ?>
                                    (স্টক: <?php echo e($prosize->pivot->stock); ?>)
                                <?php endif; ?>
                            </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <?php endif; ?>
                </div>
                <?php endif; ?>

                
                <div class="mb-4">
                    <label class="form-label fw-semibold mb-2">পরিমাণ</label>
                    <div class="input-group">
                        <button type="button" class="btn btn-outline-secondary" onclick="decreaseQty()">-</button>
                        <input type="number" 
                               name="qty" 
                               id="product_qty" 
                               class="form-control text-center" 
                               value="1" 
                               min="1" 
                               max="<?php echo e($product->stock); ?>">
                        <button type="button" class="btn btn-outline-secondary" onclick="increaseQty()">+</button>
                    </div>
                </div>

                <div class="d-grid gap-2">
                    <form action="<?php echo e(route('reseller.cart.add')); ?>" method="POST" id="addToCartForm">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="product_id" value="<?php echo e($product->id); ?>">
                        <input type="hidden" name="qty" id="hidden_qty" value="1">
                        <input type="hidden" name="product_size" id="hidden_size" value="">
                        <input type="hidden" name="product_color" id="hidden_color" value="">
                        <button type="submit" class="btn btn-primary btn-lg rounded-pill w-100">
                            <i class="fas fa-cart-plus me-2"></i> কার্টে যোগ করুন
                        </button>
                    </form>
                    <a href="<?php echo e(route('product', $product->slug)); ?>" target="_blank" class="btn btn-outline-primary rounded-pill">
                        <i class="fas fa-external-link-alt me-2"></i> মূল ওয়েবসাইটে দেখুন
                    </a>
                    <button class="btn btn-outline-secondary rounded-pill" onclick="copyProductLink('<?php echo e(route('product', $product->slug)); ?>')">
                        <i class="fas fa-link me-2"></i> লিঙ্ক কপি করুন
                    </button>
                </div>
            </div>

            <!-- Product Info -->
            <div class="product-detail-card">
                <h6 class="fw-bold mb-3">পণ্যের তথ্য</h6>
                <table class="table table-sm">
                    <tr>
                        <td class="text-muted">ক্যাটাগরি:</td>
                        <td class="fw-semibold"><?php echo e($product->category->name ?? 'N/A'); ?></td>
                    </tr>
                    <?php if($product->subcategory): ?>
                    <tr>
                        <td class="text-muted">সাব-ক্যাটাগরি:</td>
                        <td class="fw-semibold"><?php echo e($product->subcategory->subcategoryName ?? 'N/A'); ?></td>
                    </tr>
                    <?php endif; ?>
                    <?php if($product->brand): ?>
                    <tr>
                        <td class="text-muted">ব্র্যান্ড:</td>
                        <td class="fw-semibold"><?php echo e($product->brand->name); ?></td>
                    </tr>
                    <?php endif; ?>
                    <tr>
                        <td class="text-muted">স্টক:</td>
                        <td class="fw-semibold">
                            <?php if($product->stock > 0): ?>
                                <span class="text-success"><?php echo e($product->stock); ?> পিস</span>
                            <?php else: ?>
                                <span class="text-danger">স্টক নেই</span>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <tr>
                        <td class="text-muted">প্রোডাক্ট কোড:</td>
                        <td class="fw-semibold"><?php echo e($product->product_code ?? 'N/A'); ?></td>
                    </tr>
                </table>
            </div>
        </div>
    </div>

   

<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    // Change Main Image
    function changeMainImage(src, element) {
        document.getElementById('mainProductImage').src = src;
        document.querySelectorAll('.product-thumbnail').forEach(img => {
            img.classList.remove('active');
        });
        element.classList.add('active');
    }

    // Copy Product Link
    function copyProductLink(url) {
        navigator.clipboard.writeText(url).then(function() {
            const toast = document.createElement('div');
            toast.className = 'position-fixed top-0 start-50 translate-middle-x mt-3 alert alert-success alert-dismissible fade show';
            toast.style.zIndex = '9999';
            toast.innerHTML = `
                <strong>সফল!</strong> Product link copied to clipboard!
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            `;
            document.body.appendChild(toast);
            setTimeout(() => toast.remove(), 3000);
        });
    }

    // Quantity Functions
    function increaseQty() {
        const qtyInput = document.getElementById('product_qty');
        const maxQty = parseInt(qtyInput.getAttribute('max')) || 999;
        const currentQty = parseInt(qtyInput.value) || 1;
        if (currentQty < maxQty) {
            qtyInput.value = currentQty + 1;
            document.getElementById('hidden_qty').value = qtyInput.value;
        }
    }

    function decreaseQty() {
        const qtyInput = document.getElementById('product_qty');
        const currentQty = parseInt(qtyInput.value) || 1;
        if (currentQty > 1) {
            qtyInput.value = currentQty - 1;
            document.getElementById('hidden_qty').value = qtyInput.value;
        }
    }

    // Update hidden fields and validate before submit
    document.getElementById('addToCartForm').addEventListener('submit', function(e) {
        const qtyInput = document.getElementById('product_qty');
        const sizeSelect = document.getElementById('product_size');
        const colorRadios = document.querySelectorAll('.color-radio:checked');
        
        // Update hidden fields
        document.getElementById('hidden_qty').value = qtyInput.value;
        
        if (sizeSelect) {
            document.getElementById('hidden_size').value = sizeSelect.value;
        }
        
        if (colorRadios.length > 0) {
            document.getElementById('hidden_color').value = colorRadios[0].value;
        }

        // Validate size/color if product has variants
        <?php if($productcolors->count() > 0 || $productsizes->count() > 0): ?>
            <?php if($productcolors->count() > 0): ?>
            if (colorRadios.length === 0) {
                e.preventDefault();
                alert('অনুগ্রহ করে কালর নির্বাচন করুন');
                return false;
            }
            <?php endif; ?>
            
            <?php if($productsizes->count() > 0): ?>
            if (!sizeSelect.value) {
                e.preventDefault();
                alert('অনুগ্রহ করে সাইজ নির্বাচন করুন');
                return false;
            }
            <?php endif; ?>
        <?php endif; ?>
    });

    // Update stock display when size changes
    <?php if($productsizes->count() > 0): ?>
    document.getElementById('product_size').addEventListener('change', function() {
        const selectedOption = this.options[this.selectedIndex];
        const stock = selectedOption.getAttribute('data-stock') || <?php echo e($product->stock); ?>;
        document.getElementById('stock-display').textContent = stock;
        
        // Update max quantity
        const qtyInput = document.getElementById('product_qty');
        qtyInput.setAttribute('max', stock);
        if (parseInt(qtyInput.value) > stock) {
            qtyInput.value = stock;
            document.getElementById('hidden_qty').value = stock;
        }
    });
    <?php endif; ?>

    // Update quantity input
    document.getElementById('product_qty').addEventListener('change', function() {
        document.getElementById('hidden_qty').value = this.value;
    });
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('reseller.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/creativedesignbd/ecommerce1.creativedesign.com.bd/resources/views/reseller/products/show.blade.php ENDPATH**/ ?>